.intel_syntax noprefix

.data

.text

    .global binary_search

# int binary_search(unsigned *a, unsigned n, unsigned x);
# eax                       rdi         esi         edx

binary_search:
    enter 0, 0
    
    mov r8d, 0
    mov r10d, esi
    dec r10d
    
loop:
    cmp r8d, r10d
    ja end_loop
    
    mov r9d, r8d
    add r9d, r10d
    shr r9d, 1
    
    cmp edx, [rdi + 4 * r9]
    je found_target
    jb search_left
    jmp search_right

search_left:
    # r = m - 1
    mov r10d, r9d
    dec r10d
    jmp loop

search_right:
    # l = m + 1
    mov r8d, r9d
    inc r8d
    jmp loop

end_loop:
    mov eax, -1    
    leave
    ret

found_target:
    mov eax, r9d
    leave
    ret

